within Modelica.Electrical;
package QuasiStatic "Library for quasi-static electrical single-phase and polyphase AC simulation"
  extends Modelica.Icons.Package;
  annotation (
  preferredView="info",
  Documentation(info="<html>
<dl>
  <dt><strong>Main Authors:</strong></dt>
  <dd>
<p>
  Anton Haumer<br>
  <a href=\"https://www.haumer.at/\">Technical Consulting &amp; Electrical Engineering</a><br>
  D-93049 Regensburg, Germany<br>
  email: <a href=\"mailto:a.haumer@haumer.at\">a.haumer@haumer.at</a>
</p>
<p>
  Dr. Christian Kral<br>
  <a href=\"https://christiankral.net/\">Electric Machines, Drives and Systems</a><br>
  A-1060 Vienna, Austria<br>
  email: <a href=\"mailto:dr.christian.kral@gmail.com\">dr.christian.kral@gmail.com</a> or <a href=\"mailto:mail@christiankral.net\">mail@christiankral.net</a>
</p>
</dd>
</dl>
<p>
Copyright &copy; 1998-2020, Modelica Association and contributors
</p>
</html>", revisions="<html>
<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <th>Version</th>
      <th>Revision</th>
      <th>Date</th>
      <th>Author</th>
      <th>Comment</th>
    </tr>
    <tr>
      <td>1.0.0</td>
      <td> </td>
      <td>2010-01-30</td>
      <td>A. Haumer<br>C. Kral</td>
      <td></td>
    </tr>
</table>
</html>"),
  Icon(coordinateSystem(extent={{-100,-100},{100,100}}, preserveAspectRatio=
          true), graphics={Line(
        origin={10,20},
        points={{-90,-20},{-78.7,14.2},{-71.5,33.1},{-65.1,46.4},{-59.4,54.6},{
            -53.8,59.1},{-48.2,59.8},{-42.6,56.6},{-36.9,49.7},{-31.3,39.4},{-24.9,
            24.1},{-16.83,1.2},{0.1,-50.8},{7.3,-70.2},{13.7,-84.2},{19.3,-93.1},
            {25,-98.4},{30.6,-100},{36.2,-97.6},{41.9,-91.5},{47.5,-81.9},{53.9,
            -67.2},{62,-44.8},{70,-20}},
        smooth=Smooth.Bezier)}));
end QuasiStatic;
